unit splshfrm;

interface

uses
  WinProcs, WinTypes, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls;

type
  TSplashForm = class(TForm)
    SplashImage: TImage;
    SplashTimer: TTimer;
    procedure SplashTimerTimer(Sender: TObject);
    procedure SplashEvent(var Msg: TMsg; var Handled: Boolean);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;


function ShowSplashForm(SplashTime: longint): Boolean;

function DelSplashForm: Boolean;

implementation

{$R SPLSHFRM.DFM}

{$IFDEF WINDOWS}
{$R SPLSH16.RES}
{$ENDIF}
{$IFDEF WIN32}
{$R SPLSH32.RES}
{$ENDIF}

var
  SplashForm: TSplashForm;
  SplashOn: Boolean;
  OldMessage: TMessageEvent;

procedure TSplashForm.SplashEvent(var Msg: TMsg; var Handled: Boolean);
begin
  if (Msg.Message = WM_KEYDOWN) or (Msg.Message = WM_LBUTTONDOWN) or
    (Msg.Message = WM_RBUTTONDOWN) or (Msg.Message = WM_NCLBUTTONDOWN) or
    (Msg.Message = WM_NCRBUTTONDOWN) then
  begin
    Handled := True;
    Application.OnMessage := OldMessage;
    DelSplashForm;
  end;
end;

procedure TSplashForm.SplashTimerTimer(Sender: TObject);
begin
  DelSplashForm;
end;

function ShowSplashForm(SplashTime: longint): Boolean;
begin
  Result := True;
  if not SplashOn then
  begin
    Result := False;
    SplashOn := True;
    SplashForm := TSplashForm.Create(Application);
    SplashForm.SplashImage.Picture.Bitmap.Handle :=
               LoadBitmap(hInstance,'SPLSHFRM_RES');
    SplashForm.BorderStyle := bsNone;
    SplashForm.Height := SplashForm.SplashImage.Picture.Height;
    SplashForm.Width := SplashForm.SplashImage.Picture.Width;
    SplashForm.SplashImage.Align := alClient;
    SplashForm.Position := poScreenCenter;
    SplashForm.FormStyle := fsStayOnTop;
    if SplashTime > 0 then
    begin
      SplashForm.SplashTimer.Interval := SplashTime;
      SplashForm.SplashTimer.Enabled := True;
    end else
    begin
    OldMessage := Application.OnMessage;
    Application.OnMessage := SplashForm.SplashEvent;
    end;
    SplashForm.Show;
  end;
end;

function DelSplashForm: Boolean;
begin
  Result := True;
  if SplashOn then
  begin
    Result := False;
    SplashOn := False;
    SplashForm.Free;
  end;
end;

end.
